@echo off
REM This simple utility will rename EAW add-on terrain set files to use hi-res tiles.
REM EAW was built with 2 different resolutions of terrain tiles.
REM If you are using add-on terrain, these tiles have been created as separate low-res and
REM high res tile files.
REM The low-res tiles are 128x128 pixels and named lr*.ter.
REM The high-res tiles are 256x256 pixels and named bn*.ter.
REM It appears that EAW for some reason does not use the hi-res tiles, possibly a programming REM oversite.
REM However, we can trick EAW into using them by renaming the high-res tiles to the names 
REM of the low-res tiles.
REM This way, the game accesses the low-res tiles as normal, but gets the hi-res instead.
REM The result is a better looking game, or more correctly, probably the way it was intended
REM to look in the first place.
REM It doesn't appear that the original bn*.ter files are necessary for the game to run 
REM properly, but I recommend leaving them there just in case.  If you are hurting for disk
REM space you may want to remove them and see if it causes any problems for you.
REM max188
REM
echo This utility will rename EAW add-on terrain set files to use hi-res tiles.
echo This should be run in the directory containing the terrain set to convert.
echo.
pause
cls
echo Backing up original low-res files to .bak extension
copy lr*.ter lr*.bak
echo.
echo Renaming hi-res tiles to be used by EAW
copy bn*.ter lr*.ter
cls
echo.
echo Done!  Now just copy the *.ter files to your EAW directory and you're set.
echo.
pause
