/*
 * Decompiled with CFR 0.152.
 */
package my3dz;

import java.io.InputStream;
import java.net.URL;
import my3dz.EleTable;
import my3dz.Elem;
import my3dz.Header;
import my3dz.Insert;
import my3dz.Node;
import my3dz.Normal;
import my3dz.PCXClass;
import my3dz.Sequence;
import my3dz.UplaArray;
import my3dz.stools;

public class C3dz {
    public boolean LoadOK = false;
    String homeOfThisFile;
    Header header;
    Insert[] insertArr;
    Normal[] normalArr;
    Sequence sequence;
    Node[] nodes;
    EleTable eleTable;
    Elem[] elemArr;
    short[] Data3DZ;
    PCXClass pcxPaleteArr;

    public C3dz() {
    }

    public C3dz(URL BaseName, String Filename) {
        InputStream ist3dz = null;
        byte[] myBuff = new byte[20480];
        int filesize = -255;
        try {
            URL myURL = new URL(BaseName, Filename);
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("OPEN geometry :  ").append(Filename).append(" at ").append(myURL.toString()))));
            this.homeOfThisFile = myURL.toString();
            try {
                ist3dz = myURL.openStream();
                try {
                    int CheckEOF = 0;
                    filesize = 0;
                    while (CheckEOF != -1) {
                        CheckEOF = ist3dz.read();
                        if (CheckEOF == -1) continue;
                        myBuff[filesize++] = (byte)CheckEOF;
                    }
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer("Read ").append(filesize).append(" bytes from ").append(myURL))));
                    try {
                        ist3dz.close();
                    }
                    catch (Exception eClose) {
                        System.out.println("Error on Closing : ".concat(String.valueOf(String.valueOf(myURL.toString()))));
                        System.out.println(eClose.toString());
                    }
                }
                catch (Exception eRead) {
                    System.out.println("Error on Reading file : ".concat(String.valueOf(String.valueOf(myURL.toString()))));
                    System.out.println(eRead.toString());
                }
            }
            catch (Exception eOpen) {
                System.out.println("Error : I cannot open the Stream : ".concat(String.valueOf(String.valueOf(myURL.toString()))));
                System.out.println(eOpen.toString());
            }
        }
        catch (Exception eUrl) {
            System.out.println("Error : bad filename or bad URL path in ".concat(String.valueOf(String.valueOf(Filename))));
            System.out.println(eUrl.toString());
        }
        if (filesize > 0) {
            int[] Data3D = new int[filesize];
            stools.byteArraytoIntArray(myBuff, Data3D);
            this.BuildC3dz(Data3D);
            this.LoadOK = true;
        } else {
            System.out.println("I could not create the geometry from ".concat(String.valueOf(String.valueOf(Filename))));
        }
    }

    private void BuildC3dz(int[] Dat) {
        int j;
        this.Data3DZ = new short[Dat.length];
        for (int j2 = 0; j2 < this.Data3DZ.length; ++j2) {
            this.Data3DZ[j2] = (short)Dat[j2];
        }
        this.header = new Header(this.separa(0, 22));
        int pos = 22;
        int par = this.header.Par;
        int nod = this.header.Nod;
        int ele = this.header.Ele;
        if (par > 1) {
            this.insertArr = new Insert[par];
            this.insertArr[0] = new Insert(0, new int[8]);
            for (j = 1; j < par; ++j) {
                this.insertArr[j] = new Insert(j, this.separa(pos, 8));
                pos += 8;
            }
        }
        if (ele > 0) {
            this.normalArr = new Normal[ele];
            for (j = 0; j < ele; ++j) {
                this.normalArr[j] = new Normal(j, this.separa(pos, 12));
                pos += 12;
            }
        }
        this.sequence = new Sequence(ele, this.separa(pos, (ele + 1) * 2));
        pos += (ele + 1) * 2;
        this.nodes = new Node[nod];
        for (j = 0; j < nod; ++j) {
            this.nodes[j] = new Node(j, this.separa(pos, 8));
            pos += 8;
        }
        this.eleTable = new EleTable(ele, this.separa(pos, ele * 2), Dat.length);
        pos += ele * 2;
        this.elemArr = new Elem[ele];
        for (int j3 = 0; j3 < ele; ++j3) {
            int[] Ender = this.eleTable.GetEleAdd(j3);
            int subnum = 0;
            this.elemArr[j3] = new Elem(j3, subnum, this.separa(Ender[0], Ender[1]));
        }
    }

    private int[] separa(int DataOffset, int DataLength) {
        int[] res = new int[DataLength];
        if (this.Data3DZ != null) {
            int i = DataOffset;
            for (int j = 0; j < DataLength; ++j) {
                res[j] = this.Data3DZ[i];
                ++i;
            }
        }
        return res;
    }

    public String toString() {
        int j;
        StringBuffer res = new StringBuffer(40960);
        res.append(" ;Converter 2.0 by Alessandro Borges (c)2001.\n");
        res.append(String.valueOf(String.valueOf(new StringBuffer(" ;").append(this.homeOfThisFile).append(" text file version. This is a text version of a 3DZ file\n"))));
        res.append(" ; Error checking was NOT performed. Be careful when modifying this file\n");
        res.append(" ; There are 6 sectors : HEADER , INSERT, NORMAL, SEQUENCE, POINTS and ELEMENTS\n");
        res.append(" ; The  [END] statement indicates the end of a sector\n");
        res.append(" ; The  [EOF] statement indicates the end of this file\n");
        res.append(" ; Comments starts with ;\n");
        res.append(this.header.toString());
        res.append("[INSERT]\n;the entry I000 have all values zero\n;I000= _code  _num   _YY   _ZZ   _XX\n");
        for (j = 1; j < this.header.Par; ++j) {
            res.append(this.insertArr[j].toString());
        }
        res.append("[END]\n");
        res.append("\n[NORMAL]\n;Normal =    NY      NZ       NX       DD      Flags\n");
        for (j = 0; j < this.header.Ele; ++j) {
            res.append(this.normalArr[j].toString());
        }
        res.append("\n[END]\n");
        res.append(this.sequence.toString());
        res.append("\n\n[POINTS]\n");
        res.append(";point=     YY      ZZ     XX   Insert_Ower\n");
        for (j = 0; j < this.header.Nod; ++j) {
            res.append(this.nodes[j].toString());
        }
        res.append("\n[END]\n");
        res.append("\n\n[ELEMENTS]\n;Element= codes ... end_code\n");
        for (j = 0; j < this.header.Ele; ++j) {
            res.append(this.elemArr[j].toString());
        }
        res.append("\n[END]\n");
        res.append(" ; end of this file\n[EOF]\n");
        return res.toString();
    }

    public String toString2() {
        int j;
        StringBuffer res = new StringBuffer(40960);
        res.append(" ;Converter 2.0 by Alessandro Borges (c)2001.\n");
        res.append(String.valueOf(String.valueOf(new StringBuffer(" ;").append(this.homeOfThisFile).append(" text file version. This is a text version of a 3DZ file\n"))));
        res.append(" ; Error checking was NOT performed. Be careful when modifying this file\n");
        res.append(" ; There are 6 sectors : HEADER , INSERT, NORMAL, SEQUENCE, POINTS and ELEMENTS\n");
        res.append(" ; The  [END] statement indicates the end of a sector\n");
        res.append(" ; The  [EOF] statement indicates the end of this file\n");
        res.append(" ; Comments starts with ;\n");
        res.append(this.header.toString());
        res.append("[INSERT]\n;the entry I000 have all values zero\n;I000= _code  _num   _YY   _ZZ   _XX\n");
        for (j = 1; j < this.header.Par; ++j) {
            res.append(this.insertArr[j].toString());
        }
        res.append("[END]\n");
        res.append("\n[NORMAL]\n;Normal =    NY      NZ       NX       DD      Flags\n");
        for (j = 0; j < this.header.Ele; ++j) {
            res.append(this.normalArr[j].toString());
        }
        res.append("\n[END]\n");
        res.append(this.sequence.toString());
        res.append("\n\n[POINTS]\n");
        res.append(";point=     YY      ZZ     XX   Insert_Ower\n");
        for (j = 0; j < this.header.Nod; ++j) {
            res.append(this.nodes[j].toString());
        }
        res.append("\n[END]\n");
        res.append("\n\n[ELEMENTS]\n;Element= codes ... end_code\n");
        for (j = 0; j < this.header.Ele; ++j) {
            res.append(this.elemArr[j].toString2());
        }
        res.append("\n[END]\n");
        res.append(" ; end of this file\n[EOF]\n");
        return res.toString();
    }

    public int getNumberAllFaces(int[][] SelFF) {
        int res = 0;
        for (int j = 0; j < this.header.Ele; ++j) {
            res += this.elemArr[j].getNumberofFaces(SelFF);
        }
        return res;
    }

    public void getAllFaces(float[] Vertex, int[] VertexI, int[] ColorI, float[] Map0, int[] MapOI, int[] Material, int indice, int[][] selFF) {
        int InternalIndex = indice;
        for (int j = 0; j < this.header.Ele; ++j) {
            indice = InternalIndex = this.elemArr[j].getFaces(VertexI, ColorI, Map0, MapOI, Material, indice, selFF);
        }
        indice = InternalIndex;
        UplaArray ua = new UplaArray(Map0, MapOI, 2);
        Map0 = ua.getOptimizedArray();
        MapOI = ua.getOptimizedIndex();
        ua.selfDestroy();
        ua = new UplaArray(Vertex, VertexI, 3);
        Vertex = ua.getOptimizedArray();
        VertexI = ua.getOptimizedIndex();
        ua.selfDestroy();
    }

    public float[] getVertexNodes() {
        float[] res = new float[this.header.Nod * 3];
        if (this.header.Par > 1) {
            int i = 0;
            for (int j = 0; j < this.header.Nod; ++j) {
                int Ower = this.nodes[j]._ower;
                res[i++] = this.nodes[j].XX + this.insertArr[Ower].Ixx;
                res[i++] = this.nodes[j].YY + this.insertArr[Ower].Iyy;
                res[i++] = -(this.nodes[j].ZZ + this.insertArr[Ower].Izz);
            }
        } else {
            int i = 0;
            for (int j = 0; j < this.header.Nod; ++j) {
                int Ower = this.nodes[j]._ower;
                res[i++] = this.nodes[j].XX;
                res[i++] = this.nodes[j].YY;
                res[i++] = -this.nodes[j].ZZ;
            }
        }
        return res;
    }

    public Node[] getHardpoint(int identif) {
        Node[] res = new Node[]{new Node(0, 0, 0, 0)};
        for (int j = 0; j < this.elemArr.length; ++j) {
            boolean foundEnd;
            Elem elem = this.elemArr[j];
            do {
                foundEnd = true;
                if (elem.Tipo == 2 && elem.Identifier == identif) {
                    Node no = this.nodes[elem.HardPointNode];
                    res = this.incha(res, no);
                }
                if (elem.NextElem == null) continue;
                elem = elem.NextElem;
                foundEnd = false;
            } while (!foundEnd);
        }
        return res;
    }

    private Node[] incha(Node[] velho, Node adicao) {
        int j;
        Node[] res;
        if (velho != null) {
            res = new Node[velho.length + 1];
            for (j = 0; j < velho.length; ++j) {
                res[j] = new Node(velho[j].NodeNumber, velho[j]._ower, velho[j].XX, velho[j].YY, velho[j].ZZ);
            }
            j = velho.length;
        } else {
            res = new Node[1];
            j = 0;
        }
        res[j] = new Node(adicao.NodeNumber, adicao._ower, adicao.XX, adicao.YY, adicao.ZZ);
        return res;
    }
}

