@echo off
REM This batch file requires 3 parameters to work correctly

REM 1) EAW slot name to copy from, internal 4 character name one of:
REM p38h p38j p47c p47d p51b p51d bb17 b24a b26a hurr sp2a sp09 sp14 typh temp
REM mosq 109e 109g 109k 110c 110g m410 190a 190d 262a j88a j88c ju87 h111 v1v1

REM 2) Sub-folder name to store all files

REM 3) Aircraft name for display

REM ------------------------------------------- Check parameters

set slot=%1
set dir=%2
set aname=%3
set eaw=..

REM ------------------------------------------- Copying

md %dir%

REM --------------------------------------------3D Model

call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%a.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%b.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%c.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%e.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%f.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%g.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%h.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%l.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%m.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%n.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%p.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%r.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%s.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%t.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%u.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%v.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%w.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%x.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%y.3dz
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%z.3dz

if not exist %dir%\p%slot%z.3dz copy p0000z.3dz %dir%\p%slot%z.3dz

REM --------------------------------------------Textures

call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%tex.tpc 
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%tes.tpc 
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%tra.tpc 
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%v.tpc 
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%vtr.tpc 
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%x.tpc 
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%y.tpc 
call aux_snap.bat %eaw% %dir% 3d.cdf p%slot%ytr.tpc 

REM --------------------------------------------Virtual cockpit

call aux_snap.bat %eaw% %dir% data.cdf vcg_%slot%.dat 

REM --------------------------------------------Flight model

call aux_snap.bat %eaw% %dir% data.cdf %slot%.flt 
call aux_snap.bat %eaw% . data.cdf planes.dat 
pln_out.exe %slot% %slot%.bin
copy %slot%.bin %dir%
del %slot%.bin
del planes.dat

REM --------------------------------------------Loadouts

call aux_snap.bat %eaw% . data.cdf loadout.dat 
load_out.exe %slot% %slot%.bil
copy %slot%.bil %dir%
del %slot%.bil
del loadout.dat

echo cd .. > %dir%\%dir%.bat
echo REM (dest slot) (file name seed) (Sub-folder) (Display name) >> %dir%\%dir%.bat
echo call insts.bat %slot% %slot% %dir% %aname% >> %dir%\%dir%.bat
echo cd %dir% >> %dir%\%dir%.bat
goto end


:end
